package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class PageBlockWeb {

    public static class Prop {
        private Prop() {
        }

        public static final String PAGE_ID = "page_id";
        public static final String BLOCK_IDS = "block_ids";
    }

    @ApiModelProperty(required = true, notes = "id пейджа")
    @JsonProperty(Prop.PAGE_ID)
    private Long pageId;

    @ApiModelProperty(notes = "id блоков")
    @JsonProperty(Prop.BLOCK_IDS)
    private List<Long> blockIds;

    public PageBlockWeb() {
    }

    public PageBlockWeb(Long pageId, List<Long> blockIds) {
        this.pageId = pageId;
        this.blockIds = blockIds;
    }

    public Long getPageId() {
        return pageId;
    }

    public List<Long> getBlockIds() {
        return blockIds;
    }
}
