package ru.yandex.direct.web.core.entity.inventori.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class PlatformCorrectionsWeb {

    @ApiModelProperty(notes = "корректировка на desktop")
    @JsonProperty(value = "desktop")
    private Integer desktop;

    @ApiModelProperty(notes = "корректировка мобильные устройства")
    @JsonProperty(value = "mobile")
    private Integer mobile;

    @ApiModelProperty(notes = "таргетинг на мобильную ОС")
    @JsonProperty(value = "mobile_os_type")
    private MobileOsTypeWeb mobileOsType;

    public PlatformCorrectionsWeb() {
    }

    public PlatformCorrectionsWeb(Integer desktop, Integer mobile, MobileOsTypeWeb mobileOsType) {
        this.desktop = desktop;
        this.mobile = mobile;
        this.mobileOsType = mobileOsType;
    }

    public Integer getDesktop() {
        return desktop;
    }

    public Integer getMobile() {
        return mobile;
    }

    public MobileOsTypeWeb getMobileOsType() {
        return mobileOsType;
    }
}
