package ru.yandex.direct.web.core.entity.inventori.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class ReachOfflineResult {

    @ApiModelProperty(notes = "ID запроса")
    @JsonProperty("requestId")
    private String requestId;

    @ApiModelProperty(notes = "охват")
    @JsonProperty("reach")
    private Long reach;

    @ApiModelProperty(notes = "емкость OTS")
    @JsonProperty("ots_capacity")
    private Long otsCapacity;

    @ApiModelProperty(notes = "охват меньше чем")
    @JsonProperty("reach_less_than")
    private Long reachLessThan;

    public ReachOfflineResult() {
    }

    public ReachOfflineResult(String requestId, Long reach, Long otsCapacity, Long reachLessThan) {
        this.requestId = requestId;
        this.reach = reach;
        this.otsCapacity = otsCapacity;
        this.reachLessThan = reachLessThan;
    }

    public String getRequestId() {
        return requestId;
    }

    public ReachOfflineResult withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public Long getReach() {
        return reach;
    }

    public ReachOfflineResult withReach(Long reach) {
        this.reach = reach;
        return this;
    }

    public Long getOtsCapacity() {
        return otsCapacity;
    }

    public ReachOfflineResult withOtsCapacity(Long otsCapacity) {
        this.otsCapacity = otsCapacity;
        return this;
    }

    public Long getReachLessThan() {
        return reachLessThan;
    }

    public ReachOfflineResult withReachLessThan(Long reachLessThan) {
        this.reachLessThan = reachLessThan;
        return this;
    }
}
