package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "Запрос прогноза охвата в inventori для outdoor")
public class ReachOutdoorRequest {

    public static class Prop {
        private Prop() {
        }

        public static final String CAMPAIGN_ID = "campaign_id";
        public static final String ADGROUP_ID = "adgroup_id";
        public static final String VIDEO_CREATIVE_IDS = "video_creative_ids";
        public static final String PAGE_BLOCKS = "page_blocks";
    }

    @ApiModelProperty(notes = "ID кампании")
    @JsonProperty(Prop.CAMPAIGN_ID)
    private Long campaignId;

    @ApiModelProperty(notes = "ID группы объявлений")
    @JsonProperty(Prop.ADGROUP_ID)
    private Long adgroupId;

    @ApiModelProperty(notes = "ID видео креативов")
    @JsonProperty(Prop.VIDEO_CREATIVE_IDS)
    private List<Long> videoCreativeIds;

    @ApiModelProperty(notes = "список рекламных щитов")
    @JsonProperty(Prop.PAGE_BLOCKS)
    private List<PageBlockWeb> pageBlocks;

    public ReachOutdoorRequest() {
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public ReachOutdoorRequest withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAdgroupId() {
        return adgroupId;
    }

    public ReachOutdoorRequest withAdgroupId(Long adgroupId) {
        this.adgroupId = adgroupId;
        return this;
    }

    public List<Long> getVideoCreativeIds() {
        return videoCreativeIds;
    }

    public ReachOutdoorRequest withVideoCreativeIds(List<Long> videoCreativeIds) {
        this.videoCreativeIds = videoCreativeIds;
        return this;
    }

    public List<PageBlockWeb> getPageBlocks() {
        return pageBlocks;
    }

    public ReachOutdoorRequest withPageBlocks(List<PageBlockWeb> pageBlocks) {
        this.pageBlocks = pageBlocks;
        return this;
    }
}
