package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class ReachRecommendationResult {
    private String requestId;

    private List<BannerFormatIncreasePercent> bannerFormats;

    public ReachRecommendationResult() {
    }

    public ReachRecommendationResult(String requestId, List<BannerFormatIncreasePercent> bannerFormats) {
        this.requestId = requestId;
        this.bannerFormats = bannerFormats;
    }

    @ApiModelProperty(notes = "ID запроса")
    @JsonProperty("requestId")
    public String getRequestId() {
        return requestId;
    }

    @ApiModelProperty(notes = "прогноз без учета крипты и метрики")
    @JsonProperty("banner_formats")
    public List<BannerFormatIncreasePercent> getBannerFormatIncreasePercent() {
        return bannerFormats;
    }

}
