package ru.yandex.direct.web.core.entity.inventori.model;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.inventori.model.request.GroupType;

@ApiModel(description = "Запрос прогноза охвата в inventori")
public class ReachRequest {

    @ApiModelProperty(notes = "география")
    @JsonProperty("geo")
    private Set<Integer> geo;

    @ApiModelProperty(notes = "ID группы объявлений")
    @JsonProperty("adgroup_id")
    private Long adgroupId;

    @ApiModelProperty(notes = "форматы баннеров")
    @JsonProperty("block_sizes")
    private List<BlockSize> blockSizes;

    @ApiModelProperty(notes = "форматы видео креативов")
    @JsonProperty("video_creatives")
    private List<VideoCreativeWeb> videoCreatives;

    @ApiModelProperty(notes = "форматы видео креативов")
    @JsonProperty("audio_creatives")
    private List<AudioCreativeWeb> audioCreatives;

    @ApiModelProperty(notes = "формулы ретаргетинга по аудиториям/сегментам")
    @JsonProperty("conditions")
    private List<Condition> conditions;

    @ApiModelProperty(notes = "ID кампании")
    @JsonProperty("campaign_id")
    private Long campaignId;

    @ApiModelProperty(notes = "исключенные домены")
    @JsonProperty("excluded_domains")
    private Set<String> excludedDomains;

    @ApiModelProperty(notes = "корректировки ставок на устройства")
    @JsonProperty("platform_corrections")
    private PlatformCorrectionsWeb platformCorrectionsWeb;

    @ApiModelProperty(notes = "brandsafety")
    @JsonProperty("excluded_bs_categories")
    private List<String> excludedBsCategories;

    @ApiModelProperty(notes = "тип группы объявлений")
    @JsonProperty("group_type")
    private GroupType groupType;

    @ApiModelProperty(notes = "имеется ли среди креативов адаптив")
    @JsonProperty("has_adaptive_creative")
    private Boolean hasAdaptiveCreative;

    @ApiModelProperty(notes = "теги БК на группу")
    @JsonProperty("target_tags")
    private List<String> targetTags;

    public ReachRequest() {
    }

    public ReachRequest(
            Set<Integer> geo, Long adgroupId, List<BlockSize> blockSizes, List<VideoCreativeWeb> videoCreatives,
            List<AudioCreativeWeb> audioCreatives, List<Condition> conditions, Long campaignId,
            Set<String> excludedDomains, PlatformCorrectionsWeb platformCorrections, @Nullable GroupType groupType,
            List<String> targetTags) {
        this.geo = geo;
        this.adgroupId = adgroupId;
        this.blockSizes = blockSizes;
        this.videoCreatives = videoCreatives;
        this.audioCreatives = audioCreatives;
        this.conditions = conditions;
        this.campaignId = campaignId;
        this.excludedDomains = excludedDomains;
        this.platformCorrectionsWeb = platformCorrections;
        this.groupType = groupType;
        this.targetTags = targetTags;
    }

    public Set<Integer> getGeo() {
        return geo;
    }

    public Long getAdgroupId() {
        return adgroupId;
    }

    public List<BlockSize> getBlockSizes() {
        return blockSizes;
    }

    public List<VideoCreativeWeb> getVideoCreatives() {
        return videoCreatives;
    }

    public List<AudioCreativeWeb> getAudioCreatives() {
        return audioCreatives;
    }

    public List<Condition> getConditions() {
        return conditions;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Set<String> getExcludedDomains() {
        return excludedDomains;
    }

    public PlatformCorrectionsWeb getPlatfromCorrectionsWeb() {
        return platformCorrectionsWeb;
    }

    public GroupType getGroupType() {
        return groupType;
    }

    public Boolean getHasAdaptiveCreative() {
        return hasAdaptiveCreative;
    }

    public List<String> getTargetTags() {
        return targetTags;
    }

    public List<String> getExcludedBsCategories() { return excludedBsCategories; }

    public ReachRequest withGeo(Set<Integer> geo) {
        this.geo = geo;
        return this;
    }

    public ReachRequest withAdgroupId(Long adgroupId) {
        this.adgroupId = adgroupId;
        return this;
    }

    public ReachRequest withExcludedBsCategories(List<String> excludedBsCategories) {
        this.excludedBsCategories = excludedBsCategories;
        return this;
    }

    public ReachRequest withBlockSizes(List<BlockSize> blockSizes) {
        this.blockSizes = blockSizes;
        return this;
    }

    public ReachRequest withVideoCreatives(List<VideoCreativeWeb> videoCreatives) {
        this.videoCreatives = videoCreatives;
        return this;
    }

    public ReachRequest withAudioCreatives(List<AudioCreativeWeb> audioCreatives) {
        this.audioCreatives = audioCreatives;
        return this;
    }

    public ReachRequest withConditions(List<Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public ReachRequest withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public ReachRequest withExcludedDomains(Set<String> excludedDomains) {
        this.excludedDomains = excludedDomains;
        return this;
    }

    public ReachRequest withPlatformCorrectionsWeb(PlatformCorrectionsWeb platformCorrectionsWeb) {
        this.platformCorrectionsWeb = platformCorrectionsWeb;
        return this;
    }

    public ReachRequest withGroupType(GroupType groupType) {
        this.groupType = groupType;
        return this;
    }

    public ReachRequest withHasAdaptiveCreative(Boolean hasAdaptiveCreative) {
        this.hasAdaptiveCreative = hasAdaptiveCreative;
        return this;
    }

    public ReachRequest withTargetTags(List<String> targetTags) {
        this.targetTags = targetTags;
        return this;
    }
}
