package ru.yandex.direct.web.core.entity.inventori.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class ReachResult {
    @ApiModelProperty(notes = "ID запроса")
    @JsonProperty("requestId")
    private String requestId;

    @ApiModelProperty(notes = "прогноз без учета крипты и метрики")
    @JsonProperty("basic")
    private ReachInfo basic;

    @ApiModelProperty(notes = "прогноз с учетом крипты и метрики")
    @JsonProperty("detailed")
    private ReachInfo detailed;

    public ReachResult() {
    }

    public ReachResult(String requestId, ReachInfo basic, ReachInfo detailed) {
        this.requestId = requestId;
        this.basic = basic;
        this.detailed = detailed;
    }

    public String getRequestId() {
        return requestId;
    }

    public ReachInfo getBasic() {
        return basic;
    }

    public ReachInfo getDetailed() {
        return detailed;
    }
}
