package ru.yandex.direct.web.core.entity.inventori.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class TrafficTypeCorrectionsWeb {
    @ApiModelProperty(notes = "корректировка на банер")
    @JsonProperty("banner")
    private Integer banner;
    @ApiModelProperty(notes = "корректировка на видео inpage")
    @JsonProperty("video_inpage")
    private Integer videoInpage;
    @ApiModelProperty(notes = "корректировка на видео instream")
    @JsonProperty("video_instream")
    private Integer videoInstream;
    @ApiModelProperty(notes = "корректировка на видео в приложениях")
    @JsonProperty("video_interstitial")
    private Integer videoInterstitial;

    @ApiModelProperty(notes = "корректировка на видео в объявлениях")
    @JsonProperty("video_inbanner")
    private Integer videoInbanner;

    @ApiModelProperty(notes = "корректировка на видео rewarded")
    @JsonProperty("video_rewarded")
    private Integer videoRewarded;

    public TrafficTypeCorrectionsWeb() {
    }

    public TrafficTypeCorrectionsWeb(Integer banner, Integer videoInpage, Integer videoInstream,
                                     Integer videoInterstitial, Integer videoInbanner, Integer videoRewarded) {
        this.banner = banner;
        this.videoInpage = videoInpage;
        this.videoInstream = videoInstream;
        this.videoInterstitial = videoInterstitial;
        this.videoInbanner = videoInbanner;
        this.videoRewarded = videoRewarded;
    }

    public Integer getBanner() {
        return banner;
    }

    public Integer getVideoInpage() {
        return videoInpage;
    }

    public Integer getVideoInstream() {
        return videoInstream;
    }

    public Integer getVideoInterstitial() {
        return videoInterstitial;
    }

    public Integer getVideoInbanner() {
        return videoInbanner;
    }

    public Integer getVideoRewarded() {
        return videoRewarded;
    }
}
