package ru.yandex.direct.web.core.entity.inventori.validation;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.validation.result.DefectId;

public class CampaignDefectIds {

    public enum CampaignDefects implements DefectId<Long> {
        /**
         * В запросе указана несуществующая кампания
         */
        CAMPAIGN_NOT_EXISTS,
        /**
         * В запросе указана удаленная кампания
         */
        CAMPAIGN_ALREADY_DELETED
    }

    public enum StrategyDefects implements DefectId<StrategyName> {
        /**
         * В запросе указана кампания с невалидной стратегией
         */
        INVALID_CAMPAIGN_STRATEGY
    }

    public enum GroupsDefects implements DefectId<List<AdGroupType>> {
        /**
         * В запросе указана кампания содержащая не заархивированную группу с типом, который больше не используется
         */
        INVALID_GROUP_TYPE
    }

    public enum CampaignTypeDefects implements DefectId<CampaignType> {
        /**
         * В запросе указана кампания с невалидным типом
         */
        INVALID_CAMPAIGN_TYPE
    }
}
