package ru.yandex.direct.web.core.entity.inventori.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.DefectId;

@ParametersAreNonnullByDefault
public class InventoriDefectIds {
    private InventoriDefectIds() {
    }

    public enum Gen implements DefectId<Object> {
        UNSUPPORTED_ERROR,
        INTERNAL_ERROR,
        NO_SUITABLE_ADGROUPS,
        CONTAINS_KEYWORD_ADGROUPS,
        NO_GROUPS
    }

    public enum String implements DefectId<StringDefectParams> {
        INVALID_DATES,
        INVALID_REQUEST,
        INVALID_RF,
        UNKNOWN_SEGMENTS,
        UNSUPPORTED_SEGMENTS,
    }

    public enum Number implements DefectId<NumberDefectParams> {
        LOW_REACH,
        INVALID_BUDGET,
        INVALID_CPM
    }
}
