package ru.yandex.direct.web.core.entity.inventori.validation;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

public interface InventoriDefectTranslations extends TranslationBundle {

    InventoriDefectTranslations INSTANCE = I18NBundle.implement(InventoriDefectTranslations.class);

    @MessageFormatStub("Кампания с id {0} не найдена")
    Translatable campaignNotFound(Long campaignId);

    @MessageFormatStub("Кампания с id {0} уже удалена")
    Translatable campaignAlreadyDeleted(Long campaignId);

    @MessageFormatStub("Прайсовая кампания с id {0} имеет statusApprove отличный от Yes")
    Translatable cpmPriceCampaignIsNotApproved(Long campaignId);

    @MessageFormatStub("Кампания с id {0} имеет невалидный тип стратегии: {1}")
    Translatable invalidCampaignStrategy(Long campaignId, StrategyName strategyName);

    @MessageFormatStub("Кампания с id {0} имеет неподдерживаемые типы групп: {1}")
    Translatable invalidGroupTypes(Long campaignId, List<AdGroupType> strategyName);

    @MessageFormatStub("Кампания с id {0} имеет невалидный тип: {1}")
    Translatable invalidCampaignType(Long campaignId, CampaignType strategyName);

    @MessageFormatStub("Кампания с id {0} поймала ошибку: {1}")
    Translatable unexpectedInventoryProblemWithCampaign(Long campaignId, String message);
}
