package ru.yandex.direct.web.core.entity.inventori.validation;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignDefects.CAMPAIGN_ALREADY_DELETED;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignDefects.CAMPAIGN_NOT_EXISTS;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignTypeDefects.INVALID_CAMPAIGN_TYPE;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.GroupsDefects.INVALID_GROUP_TYPE;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.StrategyDefects.INVALID_CAMPAIGN_STRATEGY;

public class InventoriDefects {

    public static Defect campaignNotFound() {
        return new Defect<>(CAMPAIGN_NOT_EXISTS);
    }

    public static Defect campaignAlreadyDeleted() {
        return new Defect<>(CAMPAIGN_ALREADY_DELETED);
    }

    public static Defect<StrategyName> invalidCampaignStrategy(StrategyName strategyName) {
        return new Defect<>(INVALID_CAMPAIGN_STRATEGY, strategyName);
    }

    public static Defect<CampaignType> invalidCampaignType(CampaignType campaignType) {
        return new Defect<>(INVALID_CAMPAIGN_TYPE, campaignType);
    }

    public static Defect<List<AdGroupType>> invalidAdGroupType(List<AdGroupType> adGroupTypes) {
        return new Defect<>(INVALID_GROUP_TYPE, adGroupTypes);
    }
}
