package ru.yandex.direct.web.core.entity.mobilecontent.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ApiMobileContent {
    @JsonProperty("store")
    private String store;

    @JsonProperty("app_id")
    private String appId;

    @JsonProperty("lang")
    private String lang;

    @Nullable
    @JsonProperty("bundle")
    private String bundle;

    @JsonProperty("name")
    private String name;

    @Nullable
    @JsonProperty("icon")
    private String icon;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("publisher")
    private String publisher;

    @Nullable
    @JsonProperty("website")
    private String website;

    @Nullable
    @JsonProperty("rating_count")
    private Long ratingCount;

    public String getLang() {
        return lang;
    }

    public ApiMobileContent withStore(final String store) {
        this.store = store;
        return this;
    }

    public ApiMobileContent withAppId(final String appId) {
        this.appId = appId;
        return this;
    }

    public ApiMobileContent withLang(final String lang) {
        this.lang = lang;
        return this;
    }

    public ApiMobileContent withBundle(final @Nullable String bundle) {
        this.bundle = bundle;
        return this;
    }

    public ApiMobileContent withName(final String name) {
        this.name = name;
        return this;
    }

    public ApiMobileContent withIcon(final @Nullable String icon) {
        this.icon = icon;
        return this;
    }

    public ApiMobileContent withCurrency(final String currency) {
        this.currency = currency;
        return this;
    }

    public ApiMobileContent withPublisher(final String publisher) {
        this.publisher = publisher;
        return this;
    }

    public ApiMobileContent withWebsite(final @Nullable String website) {
        this.website = website;
        return this;
    }

    public ApiMobileContent withRatingCount(final @Nullable Long ratingCount) {
        this.ratingCount = ratingCount;
        return this;
    }
}
