package ru.yandex.direct.web.core.entity.mobilecontent.model;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

@SuppressWarnings("unused")
@ParametersAreNonnullByDefault
public class WebMobileApp {
    public static final String TRACKERS = "trackers";

    @JsonProperty
    private Long id;
    @JsonProperty(required = true)
    private String name;
    @JsonProperty(required = true)
    private String storeHref;
    @JsonProperty(required = true)
    private Store store;

    @JsonProperty(required = true)
    private Long mobileContentId;
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @ApiModelProperty(readOnly = true)
    private WebMobileContent mobileContent;

    @JsonProperty
    @Nullable
    private Long domainId;
    @JsonProperty
    @Nullable
    private String domain;

    @JsonProperty
    @Nullable
    private Action primaryAction;
    @JsonProperty
    @Nullable
    private Set<DisplayedAttribute> displayedAttributes;
    @JsonProperty
    @Nullable
    private String minOsVersion;

    @JsonProperty
    @Nullable
    private Set<DeviceType> deviceTypeTargeting;
    @JsonProperty
    @Nullable
    private Set<Network> networkTargeting;
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @Nullable
    private Set<Long> geoTargeting;

    @JsonProperty(required = true)
    private List<WebMobileAppTracker> trackers;
    @JsonProperty
    private List<String> files;
    @JsonProperty
    private Boolean isAppMetrika; // todo удалить в https://st.yandex-team.ru/DIRECT-143135

    @JsonProperty
    @Nullable
    private Long appMetrikaApplicationId;

    @JsonProperty
    @Nullable
    private List<WebMobileEvent> mobileEvents;

    @JsonProperty
    private List<Long> campaignsWithSkadSlots;

    @JsonProperty
    private Boolean hasVerification;

    @JsonProperty
    private Integer busySkadNetworkSlotsCount;

    @JsonProperty
    private Integer skadNetworkSlotsCount;

    public List<Long> getCampaignsWithSkadSlots() {
        return campaignsWithSkadSlots;
    }

    public void setCampaignsWithSkadSlots(List<Long> campaignsWithSkadSlots) {
        this.campaignsWithSkadSlots = campaignsWithSkadSlots;
    }

    public Boolean getHasVerification() {
        return hasVerification;
    }

    public void setHasVerification(Boolean hasVerification) {
        this.hasVerification = hasVerification;
    }

    public Integer getBusySkadNetworkSlotsCount() {
        return busySkadNetworkSlotsCount;
    }

    public void setBusySkadNetworkSlotsCount(Integer busySkadNetworkSlotsCount) {
        this.busySkadNetworkSlotsCount = busySkadNetworkSlotsCount;
    }

    public Integer getSkadNetworkSlotsCount() {
        return skadNetworkSlotsCount;
    }

    public void setSkadNetworkSlotsCount(Integer skadNetworkSlotsCount) {
        this.skadNetworkSlotsCount = skadNetworkSlotsCount;
    }

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getStoreHref() {
        return storeHref;
    }

    public Store getStore() {
        return store;
    }

    public Long getMobileContentId() {
        return mobileContentId;
    }

    public WebMobileContent getMobileContent() {
        return mobileContent;
    }

    @Nullable
    public Long getDomainId() {
        return domainId;
    }

    @Nullable
    public String getDomain() {
        return domain;
    }

    @Nullable
    public Action getPrimaryAction() {
        return primaryAction;
    }

    @Nullable
    public Set<DisplayedAttribute> getDisplayedAttributes() {
        return displayedAttributes;
    }

    @Nullable
    public String getMinOsVersion() {
        return minOsVersion;
    }

    @Nullable
    public Set<DeviceType> getDeviceTypeTargeting() {
        return deviceTypeTargeting;
    }

    @Nullable
    public Set<Network> getNetworkTargeting() {
        return networkTargeting;
    }

    @Nullable
    public Set<Long> getGeoTargeting() {
        return geoTargeting;
    }

    public List<WebMobileAppTracker> getTrackers() {
        return trackers;
    }

    public List<String> getFiles() {
        return files;
    }

    public Boolean getIsAppMetrika() {
        return isAppMetrika;
    }

    @Nullable
    public Long getAppMetrikaApplicationId() {
        return appMetrikaApplicationId;
    }

    @Nullable
    public List<WebMobileEvent> getMobileEvents() {
        return mobileEvents;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStoreHref(String storeHref) {
        this.storeHref = storeHref;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public void setMobileContentId(Long mobileContentId) {
        this.mobileContentId = mobileContentId;
    }

    public void setMobileContent(WebMobileContent mobileContent) {
        this.mobileContent = mobileContent;
    }

    public void setDomainId(@Nullable Long domainId) {
        this.domainId = domainId;
    }

    public void setDomain(@Nullable String domain) {
        this.domain = domain;
    }

    public void setPrimaryAction(@Nullable Action primaryAction) {
        this.primaryAction = primaryAction;
    }

    public void setDisplayedAttributes(
            @Nullable Set<DisplayedAttribute> displayedAttributes) {
        this.displayedAttributes = displayedAttributes;
    }

    public void setMinOsVersion(@Nullable String minOsVersion) {
        this.minOsVersion = minOsVersion;
    }

    public void setDeviceTypeTargeting(@Nullable Set<DeviceType> deviceTypeTargeting) {
        this.deviceTypeTargeting = deviceTypeTargeting;
    }

    public void setNetworkTargeting(@Nullable Set<Network> networkTargeting) {
        this.networkTargeting = networkTargeting;
    }

    public void setGeoTargeting(@Nullable Set<Long> geoTargeting) {
        this.geoTargeting = geoTargeting;
    }

    public void setTrackers(List<WebMobileAppTracker> trackers) {
        this.trackers = trackers;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public void setIsAppMetrika(Boolean isAppMetrika) {
        this.isAppMetrika = isAppMetrika;
    }

    public void setAppMetrikaApplicationId(@Nullable Long appMetrikaApplicationId) {
        this.appMetrikaApplicationId = appMetrikaApplicationId;
    }

    public WebMobileApp withId(final Long id) {
        this.id = id;
        return this;
    }

    public WebMobileApp withName(final String name) {
        this.name = name;
        return this;
    }

    public WebMobileApp withStoreHref(final String storeHref) {
        this.storeHref = storeHref;
        return this;
    }

    public WebMobileApp withStore(final Store store) {
        this.store = store;
        return this;
    }

    public WebMobileApp withMobileContentId(final Long mobileContentId) {
        this.mobileContentId = mobileContentId;
        return this;
    }

    public WebMobileApp withMobileContent(final WebMobileContent mobileContent) {
        this.mobileContent = mobileContent;
        return this;
    }

    public WebMobileApp withDomainId(final Long domainId) {
        this.domainId = domainId;
        return this;
    }

    public WebMobileApp withDomain(final String domain) {
        this.domain = domain;
        return this;
    }

    public WebMobileApp withPrimaryAction(final @Nullable Action primaryAction) {
        this.primaryAction = primaryAction;
        return this;
    }

    public WebMobileApp withDisplayedAttributes(final @Nullable Set<DisplayedAttribute> displayedAttributes) {
        this.displayedAttributes = displayedAttributes;
        return this;
    }

    public WebMobileApp withMinOsVersion(final String minOsVersion) {
        this.minOsVersion = minOsVersion;
        return this;
    }

    public WebMobileApp withDeviceTypeTargeting(final @Nullable Set<DeviceType> deviceTypeTargeting) {
        this.deviceTypeTargeting = deviceTypeTargeting;
        return this;
    }

    public WebMobileApp withNetworkTargeting(final @Nullable Set<Network> networkTargeting) {
        this.networkTargeting = networkTargeting;
        return this;
    }

    public WebMobileApp withGeoTargeting(final @Nullable Set<Long> geoTargeting) {
        this.geoTargeting = geoTargeting;
        return this;
    }

    public WebMobileApp withTrackers(final List<WebMobileAppTracker> trackers) {
        this.trackers = trackers;
        return this;
    }

    public WebMobileApp withFiles(final List<String> files) {
        this.files = files;
        return this;
    }

    public WebMobileApp withIsAppMetrika(Boolean isAppMetrika) {
        this.isAppMetrika = isAppMetrika;
        return this;
    }

    public WebMobileApp withAppMetrikaApplicationId(@Nullable Long appMetrikaApplicationId) {
        this.appMetrikaApplicationId = appMetrikaApplicationId;
        return this;
    }

    public WebMobileApp withMobileEvents(@Nullable List<WebMobileEvent> mobileEvents) {
        this.mobileEvents = mobileEvents;
        return this;
    }

    public WebMobileApp withCampaignsWithSkadSlots(List<Long> campaignsWithSkadSlots) {
        this.campaignsWithSkadSlots = campaignsWithSkadSlots;
        return this;
    }

    public WebMobileApp withHasVerification(Boolean hasVerification) {
        this.hasVerification = hasVerification;
        return this;
    }

    public WebMobileApp withBusySkadNetworkSlotsCount(Integer busySkadNetworkSlotsCount) {
        this.busySkadNetworkSlotsCount = busySkadNetworkSlotsCount;
        return this;
    }

    public WebMobileApp withSkadNetworkSlotsCount(Integer skadNetworkSlotsCount) {
        this.skadNetworkSlotsCount = skadNetworkSlotsCount;
        return this;
    }
}
