package ru.yandex.direct.web.core.entity.mobilecontent.model;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.ApiModelProperty;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@ParametersAreNonnullByDefault
public class WebMobileAppTracker {
    public static final String URL = "url";
    public static final String IMPRESSION_URL = "impressionUrl";
    public static final String USER_PARAMS = "userParams";

    @JsonProperty
    private TrackingSystem trackingSystem;

    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @ApiModelProperty(readOnly = true)
    private String trackingSystemName;

    @JsonProperty
    @Nullable
    private String trackerId;

    @JsonProperty(required = true)
    private String url;

    @JsonProperty(required = true)
    @Nullable
    private String impressionUrl;

    @JsonProperty(required = true)
    @Nullable
    private List<String> userParams;

    public TrackingSystem getTrackingSystem() {
        return trackingSystem;
    }

    public String getTrackingSystemName() {
        return trackingSystemName;
    }

    @Nullable
    public String getTrackerId() {
        return trackerId;
    }

    public String getUrl() {
        return url;
    }

    @Nullable
    public String getImpressionUrl() { return impressionUrl; }

    @Nullable
    public List<String> getUserParams() {
        return userParams;
    }

    public WebMobileAppTracker withTrackingSystem(TrackingSystem trackingSystem) {
        this.trackingSystem = trackingSystem;
        return this;
    }

    public WebMobileAppTracker withTrackingSystemName(String trackingSystemName) {
        this.trackingSystemName = trackingSystemName;
        return this;
    }

    public WebMobileAppTracker withTrackerId(@Nullable String trackerId) {
        this.trackerId = trackerId;
        return this;
    }

    public WebMobileAppTracker withUrl(String url) {
        this.url = url;
        return this;
    }

    public WebMobileAppTracker withImpressionUrl(@Nullable String impressionUrl) {
        this.impressionUrl = impressionUrl;
        return this;
    }

    public WebMobileAppTracker withUserParams(@Nullable List<String> userParams) {
        this.userParams = ifNotNull(userParams, ImmutableList::copyOf);
        return this;
    }
}
