package ru.yandex.direct.web.core.entity.mobilecontent.model;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.mobilecontent.model.AvailableAction;
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContentExternalWorldMoney;
import ru.yandex.direct.core.entity.mobilecontent.model.StoreActionForPrices;

@SuppressWarnings("unused")
@ParametersAreNonnullByDefault
public class WebMobileContent {
    @Nullable
    @JsonProperty("mobile_content_id")
    private Long id;

    @JsonProperty("content_type")
    private String contentType;

    @JsonProperty("os_type")
    private WebOsType osType;

    @JsonProperty("store_country")
    private String storeCountry;

    @JsonProperty("store_content_id")
    private String storeContentId;

    @Nullable
    @JsonProperty("bundle_id")
    private String bundleId;

    @JsonProperty("name")
    private String name;

    @JsonProperty("icon_url")
    @Nullable
    private String iconUrl;

    @JsonProperty("rating")
    @Nullable
    private BigDecimal rating;

    @JsonProperty("rating_votes")
    private Long ratingVotes;

    @Nullable
    @JsonProperty("age_label")
    private AgeLabel ageLabel;

    @Nullable
    @JsonProperty("min_os_version")
    private String minOsVersion;

    @Nullable
    @JsonProperty("available_actions")
    private Set<AvailableAction> availableActions;

    @JsonProperty("is_available")
    private Boolean isAvailable;

    @JsonProperty("is_show_icon")
    private Boolean isShowIcon;

    @JsonProperty
    @Nullable
    private String publisherDomain;


    @JsonProperty("prices")
    private Map<StoreActionForPrices, MobileContentExternalWorldMoney> prices;

    @Nullable
    public Long getId() {
        return id;
    }

    public String getContentType() {
        return contentType;
    }

    public WebOsType getOsType() {
        return osType;
    }

    public String getStoreCountry() {
        return storeCountry;
    }

    public String getStoreContentId() {
        return storeContentId;
    }

    public String getBundleId() {
        return bundleId;
    }

    public String getName() {
        return name;
    }

    @Nullable
    public String getIconUrl() {
        return iconUrl;
    }

    @Nullable
    public BigDecimal getRating() {
        return rating;
    }

    public Long getRatingVotes() {
        return ratingVotes;
    }

    @Nullable
    public AgeLabel getAgeLabel() {
        return ageLabel;
    }

    @Nullable
    public String getMinOsVersion() {
        return minOsVersion;
    }

    @Nullable
    public Set<AvailableAction> getAvailableActions() {
        return availableActions;
    }

    @JsonIgnore
    public Boolean getAvailable() {
        return isAvailable;
    }

    @JsonIgnore
    public Boolean getShowIcon() {
        return isShowIcon;
    }

    @Nullable
    public String getPublisherDomain() {
        return publisherDomain;
    }

    public Map<StoreActionForPrices, MobileContentExternalWorldMoney> getPrices() {
        return prices;
    }

    public WebMobileContent withId(final Long id) {
        this.id = id;
        return this;
    }

    public WebMobileContent withContentType(final String contentType) {
        this.contentType = contentType;
        return this;
    }

    public WebMobileContent withOsType(final WebOsType osType) {
        this.osType = osType;
        return this;
    }

    public WebMobileContent withStoreCountry(final String storeCountry) {
        this.storeCountry = storeCountry;
        return this;
    }

    public WebMobileContent withStoreContentId(final String storeContentId) {
        this.storeContentId = storeContentId;
        return this;
    }

    public WebMobileContent withBundleId(final String bundleId) {
        this.bundleId = bundleId;
        return this;
    }

    public WebMobileContent withName(final String name) {
        this.name = name;
        return this;
    }

    public WebMobileContent withIconUrl(final @Nullable String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public WebMobileContent withRating(final @Nullable BigDecimal rating) {
        this.rating = rating;
        return this;
    }

    public WebMobileContent withRatingVotes(final Long ratingVotes) {
        this.ratingVotes = ratingVotes;
        return this;
    }

    public WebMobileContent withAgeLabel(final AgeLabel ageLabel) {
        this.ageLabel = ageLabel;
        return this;
    }

    public WebMobileContent withMinOsVersion(final String minOsVersion) {
        this.minOsVersion = minOsVersion;
        return this;
    }

    public WebMobileContent withAvailableActions(final Set<AvailableAction> availableActions) {
        this.availableActions = availableActions;
        return this;
    }

    public WebMobileContent withIsAvailable(final Boolean isAvailable) {
        this.isAvailable = isAvailable;
        return this;
    }

    public WebMobileContent withIsShowIcon(final Boolean isShowIcon) {
        this.isShowIcon = isShowIcon;
        return this;
    }

    public WebMobileContent withPublisherDomain(@Nullable final String publisherDomain) {
        this.publisherDomain = publisherDomain;
        return this;
    }

    public WebMobileContent withPrices(final Map<StoreActionForPrices, MobileContentExternalWorldMoney> prices) {
        this.prices = prices;
        return this;
    }
}
