package ru.yandex.direct.web.core.entity.mobilecontent.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class WebMobileEvent {
    @JsonProperty
    private String eventName;

    @JsonProperty
    private String customEventName;

    @JsonProperty
    private Boolean isInternal;

    public String getEventName() {
        return eventName;
    }

    public String getCustomEventName() {
        return customEventName;
    }

    public Boolean getIsInternal() {
        return isInternal;
    }

    public WebMobileEvent withEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public WebMobileEvent withCustomEventName(String customEventName) {
        this.customEventName = customEventName;
        return this;
    }

    public WebMobileEvent withIsInternal(Boolean internal) {
        isInternal = internal;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        WebMobileEvent that = (WebMobileEvent) o;
        return Objects.equals(eventName, that.eventName)
                && Objects.equals(customEventName, that.customEventName)
                && Objects.equals(isInternal, that.isInternal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventName, customEventName, isInternal);
    }

    @Override
    public String toString() {
        return "WebMobileEvent{" +
                "eventName='" + eventName + '\'' +
                ", customEventName='" + customEventName + '\'' +
                ", isInternal=" + isInternal +
                '}';
    }
}
