package ru.yandex.direct.web.core.entity.mobilecontent.model;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

public enum WebOsType {
    IOS("iOS", "itunes"),
    ANDROID("Android", "gplay");

    private static final Logger logger = LoggerFactory.getLogger(WebOsType.class);
    private final String representation;
    private final String shopName;

    WebOsType(String representation, String shopName) {
        this.representation = representation;
        this.shopName = shopName;
    }

    private static final Map<String, WebOsType> osTypeByName = StreamEx.of(WebOsType.values())
            .toMap(v -> v.getRepresentation().toLowerCase(), Function.identity());

    @JsonCreator
    public static Optional<WebOsType> parse(String osType) {
        return Optional.ofNullable(osTypeByName.get(osType.toLowerCase()));
    }

    @JsonValue
    public String getRepresentation() {
        return representation;
    }

    public String getShopName() {
        return shopName;
    }

    public Optional<OsType> toCore() {
        try {
            return Optional.of(OsType.valueOf(name()));
        } catch (IllegalStateException e) {
            logger.error("Unable to convert OsType {}", this.representation);
            return Optional.empty();
        }
    }
}
