package ru.yandex.direct.web.core.entity.placement.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.placements.model1.Placement;
import ru.yandex.direct.core.entity.placements.model1.PlacementBlock;
import ru.yandex.direct.core.entity.region.RegionDesc;

public class PlacementsResponse {

    @JsonProperty("placements")
    private List<Placement> placements = new ArrayList<>();

    @JsonProperty("placement_blocks")
    private List<? extends PlacementBlock> placementBlocks = new ArrayList<>();

    @JsonProperty("zone_dictionary")
    private Map<Integer, String> zoneDictionary;

    @JsonProperty("facility_dictionary")
    private Map<Integer, String> facilityDictionary;

    @JsonProperty("region_dictionary")
    private Map<Long, RegionDesc> regionDictionary;

    public List<Placement> getPlacements() {
        return placements;
    }

    public PlacementsResponse withPlacements(
            List<Placement> placements) {
        this.placements = placements;
        return this;
    }

    public List<? extends PlacementBlock> getPlacementBlocks() {
        return placementBlocks;
    }

    public PlacementsResponse withPlacementBlocks(
            List<? extends PlacementBlock> placementBlocks) {
        this.placementBlocks = placementBlocks;
        return this;
    }

    public Map<Integer, String> getZoneDictionary() {
        return zoneDictionary;
    }

    public PlacementsResponse withZoneDictionary(Map<Integer, String> zoneDictionary) {
        this.zoneDictionary = zoneDictionary;
        return this;
    }

    public Map<Integer, String> getFacilityDictionary() {
        return facilityDictionary;
    }

    public PlacementsResponse withFacilityDictionary(
            Map<Integer, String> facilityDictionary) {
        this.facilityDictionary = facilityDictionary;
        return this;
    }

    public Map<Long, RegionDesc> getRegionDictionary() {
        return regionDictionary;
    }

    public PlacementsResponse withRegionDictionary(
            Map<Long, RegionDesc> regionDictionary) {
        this.regionDictionary = regionDictionary;
        return this;
    }
}
