package ru.yandex.direct.web.core.exception;

import javax.servlet.http.HttpServletRequest;

import org.apache.http.entity.ContentType;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.TranslatableException;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.misc.io.http.HttpHeaderNames;

class ExceptionUtils {
    private static final String AJAX_HEADER = "XMLHttpRequest";
    private static final String AJAX_HEADER_VALUE = "XMLHttpRequest";
    private static final String CONTENT_TYPE_JSON = ContentType.APPLICATION_JSON.getMimeType();

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return AJAX_HEADER_VALUE.equals(request.getHeader(AJAX_HEADER)) ||
                (request.getHeader(HttpHeaderNames.ACCEPT) != null && request.getHeader(HttpHeaderNames.ACCEPT)
                        .contains(CONTENT_TYPE_JSON));
    }

    public static WebErrorResponse toErrorResponse(TranslatableException ex, TranslationService translationService) {
        String errorText = ex.getShortMessage() == null ? null : translationService.translate(ex.getShortMessage());
        return new WebErrorResponse(ex.getCode(), errorText);
    }
}
