package ru.yandex.direct.web.core.exception;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.direct.web.core.model.WebErrorResponse;

public class RecoverableBlackboxErrorResponse extends WebErrorResponse {
    private final String recoveryUrl;

    public RecoverableBlackboxErrorResponse(String errorType, String errorText, String recoveryUrl) {
        super(errorType, errorText);
        this.recoveryUrl = recoveryUrl;
    }

    @JsonGetter
    @SuppressWarnings("unused")
    public String getRecoveryUrl() {
        return recoveryUrl;
    }
}
