package ru.yandex.direct.web.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * Инкапсулирует информацию об ошибках backend'а. Предназначен для взаимодействия с Web-frontend'ом.
 */
public class WebErrorResponse implements WebResponse {
    @JsonProperty
    private Integer code;
    @JsonProperty
    private String text;
    @JsonProperty
    private String description;

    public WebErrorResponse(Integer code, String text) {
        this.code = code;
        this.text = text;
    }

    public WebErrorResponse(String text, String description) {
        this.text = text;
        this.description = description;
    }

    @Override
    public boolean isSuccessful() {
        return false;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
