package ru.yandex.direct.web.core.model.retargeting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "id", visible = true)
@JsonSubTypes({@JsonSubTypes.Type(CryptaGoalWeb.class), @JsonSubTypes.Type(MetrikaGoalWeb.class)})
@JsonTypeIdResolver(GoalWebTypeByIdResolver.class)
@ApiModel(subTypes = {CryptaGoalWeb.class, MetrikaGoalWeb.class}, discriminator = "classType")
public class AbstractGoalWeb {
    public static final String ID_FIELD_NAME = "id";
    public static final String TYPE_FIELD_NAME = "type";
    public static final String UNION_WITH_ID_FIELD_NAME = "union_with_id";

    @JsonProperty(ID_FIELD_NAME)
    @ApiModelProperty(required = true)
    protected Long id;

    @JsonProperty(TYPE_FIELD_NAME)
    @ApiModelProperty(readOnly = true)
    protected WebGoalType type;

    @JsonProperty("name")
    @ApiModelProperty(readOnly = true, notes = "название сегмента (с учетом языка пользователя)")
    protected String name;

    @JsonProperty("classType")
    @ApiModelProperty(required = true, notes = "имя класса (CryptaGoalWeb/MetrikaGoalWeb)")
    protected String classType;

    @JsonProperty(UNION_WITH_ID_FIELD_NAME)
    @ApiModelProperty(notes = "id цели, с которой следует объединить текущую цель")
    protected Long unionWithId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebGoalType getType() {
        return type;
    }

    public void setType(WebGoalType type) {
        this.type = type;
    }

    public String getClassType() {
        return classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public Long getUnionWithId() {
        return unionWithId;
    }

    public void setUnionWithId(Long unionWithId) {
        this.unionWithId = unionWithId;
    }
}
