package ru.yandex.direct.web.core.model.retargeting;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */
public class Condition {
    public static final String TYPE_FIELD_NAME = "type";
    public static final String INTEREST_TYPE_FIELD_NAME = "interest_type";
    public static final String GOALS_FIELD_NAME = "goals";

    @JsonProperty(TYPE_FIELD_NAME)
    @ApiModelProperty(required = true)
    private RetargetingConditionRuleType conditionType;

    @JsonProperty(INTEREST_TYPE_FIELD_NAME)
    @ApiModelProperty
    private CryptaInterestTypeWeb interestType;

    @JsonProperty(GOALS_FIELD_NAME)
    @ApiModelProperty(required = true)
    private List<AbstractGoalWeb> conditionGoalWebs;

    public RetargetingConditionRuleType getConditionType() {
        return conditionType;
    }

    public Condition withConditionType(
            RetargetingConditionRuleType conditionType) {
        this.conditionType = conditionType;
        return this;
    }

    public CryptaInterestTypeWeb getInterestType() {
        return interestType;
    }

    public Condition withInterestType(
            CryptaInterestTypeWeb interestType) {
        this.interestType = interestType;
        return this;
    }

    public List<AbstractGoalWeb> getConditionGoalWebs() {
        return conditionGoalWebs;
    }

    public Condition withConditionGoalWebs(
            List<AbstractGoalWeb> conditionGoalWebs) {
        this.conditionGoalWebs = conditionGoalWebs;
        return this;
    }
}
