package ru.yandex.direct.web.core.model.retargeting;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */
@ApiModel(parent = AbstractGoalWeb.class)
public class CryptaGoalWeb extends AbstractGoalWeb {

    @JsonProperty("parent_id")
    @ApiModelProperty(required = true, notes = "ID родительского сегмента крипты (для тех, у кого нет родителя = 0)")
    private Long parentId;

    @JsonProperty("description")
    @ApiModelProperty(readOnly = true, notes = "описание сегмента (с учетом языка пользователя)")
    private String description;

    @JsonProperty("interest_type")
    @ApiModelProperty(readOnly = true,
            notes = "длительность сегмента: short-term - краткосрочные, long-term - долгосрочные, all - все")
    private CryptaInterestTypeWeb interestType;

    @JsonProperty("mutually_exclusive")
    @ApiModelProperty(readOnly = true, notes = "ID целей, которые нельзя выбрать одновременно с данной целью")
    private Set<Long> mutuallyExclusiveIds;

    @JsonProperty("can_select_all")
    @ApiModelProperty(required = false, readOnly = true,
            notes = "Только для групп, true если можно выбрать все элементы")
    private Boolean canSelectAll;

    @JsonProperty("can_not_check")
    @ApiModelProperty(required = false, readOnly = true,
            notes = "true только для фиктивного сегмента жанры кино, для остальных false")
    private Boolean canNotCheck;

    @JsonProperty("keyword")
    @ApiModelProperty(readOnly = true, notes = "ID киворда")
    private String keyword;

    @JsonProperty("keyword_value")
    @ApiModelProperty(readOnly = true, notes = "Значение киворда")
    private String keywordValue;

    @JsonProperty("order")
    @ApiModelProperty(readOnly = true, notes = "Порядок сортировки")
    private Long order;

    @JsonProperty("available_groups")
    @ApiModelProperty(readOnly = true, notes = "Типы групп, доступные для данной категории таргетинга")
    private Set<CryptaGoalAvailableGroupType> availableGroups;

    @JsonIgnore
    @ApiModelProperty(readOnly = true, hidden = true)
    private String tankerNameKey;

    public CryptaGoalWeb withId(Long id) {
        this.id = id;
        return this;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public CryptaGoalWeb withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    public CryptaGoalWeb withName(String name) {
        this.name = name;
        return this;
    }

    public CryptaGoalWeb withUnionWithId(Long unionWithId) {
        this.unionWithId = unionWithId;
        return this;
    }

    public CryptaGoalWeb withType(WebGoalType type) {
        this.type = type;
        return this;
    }

    public CryptaGoalWeb withMutuallyExclusiveIds(Set<Long> mutuallyExclusiveIds) {
        this.mutuallyExclusiveIds = mutuallyExclusiveIds;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CryptaGoalWeb withDescription(String description) {
        this.description = description;
        return this;
    }

    public CryptaInterestTypeWeb getInterestType() {
        return interestType;
    }

    public void setInterestType(CryptaInterestTypeWeb interestType) {
        this.interestType = interestType;
    }

    public CryptaGoalWeb withInterestType(CryptaInterestTypeWeb interestType) {
        this.interestType = interestType;
        return this;
    }

    public CryptaGoalWeb withCanSelectAll(Boolean canSelectAll) {
        this.canSelectAll = canSelectAll;
        return this;
    }

    public Set<Long> getMutuallyExclusiveIds() {
        return mutuallyExclusiveIds;
    }

    public Boolean getCanSelectAll() {
        return canSelectAll;
    }

    public Boolean getCanNotCheck() {
        return canNotCheck;
    }

    public CryptaGoalWeb withCanNotCheck(Boolean canNotCheck) {
        this.canNotCheck = canNotCheck;
        return this;
    }

    public String getKeyword() {
        return keyword;
    }

    public CryptaGoalWeb setKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public String getKeywordValue() {
        return keywordValue;
    }

    public CryptaGoalWeb setKeywordValue(String keywordValue) {
        this.keywordValue = keywordValue;
        return this;
    }

    public CryptaGoalWeb withKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public CryptaGoalWeb withKeywordValue(String value) {
        this.keywordValue = value;
        return this;
    }

    public String getTankerNameKey() {
        return tankerNameKey;
    }

    public void setTankerNameKey(String tankerNameKey) {
        this.tankerNameKey = tankerNameKey;
    }

    public CryptaGoalWeb withTankerNameKey(String tankerNameKey) {
        this.tankerNameKey = tankerNameKey;
        return this;
    }

    public Long getOrder() {
        return order;
    }

    public void setOrder(Long order) {
        this.order = order;
    }

    public CryptaGoalWeb withOrder(Long order) {
        this.order = order;
        return this;
    }

    public Set<CryptaGoalAvailableGroupType> getAvailableGroups() {
        return availableGroups;
    }

    public void setAvailableGroups(Set<CryptaGoalAvailableGroupType> availableGroups) {
        this.availableGroups = availableGroups;
    }

    public CryptaGoalWeb withAvailableGroups(Set<CryptaGoalAvailableGroupType> availableGroups) {
        this.availableGroups = availableGroups;
        return this;
    }
}
