package ru.yandex.direct.web.core.model.retargeting;

import java.util.Map;
import java.util.function.Function;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.retargeting.model.CryptaInterestType;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */

/**
 * Длительность сегмента из таблицы crypta_goals.interest_type:
 * short-term - краткосрочные, long-term - долгосрочные, all - все
 */
public enum CryptaInterestTypeWeb {
    short_term(CryptaInterestType.short_term),

    long_term(CryptaInterestType.long_term),

    all(CryptaInterestType.all);

    private static final Map<CryptaInterestType, CryptaInterestTypeWeb> ENUM_MAP = StreamEx.of(values())
            .mapToEntry(x -> x.coreType, Function.identity())
            .toMap();


    private final CryptaInterestType coreType;

    CryptaInterestTypeWeb(CryptaInterestType coreType) {
        this.coreType = coreType;
    }

    public static CryptaInterestTypeWeb fromCoreType(CryptaInterestType type) {
        if (type == null) {
            return null;
        }

        checkArgument(ENUM_MAP.containsKey(type), "No such enum value: {}", type);
        return ENUM_MAP.get(type);
    }

    public CryptaInterestType toCoreType() {
        return coreType;
    }
}
