package ru.yandex.direct.web.core.model.retargeting;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.SimpleType;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.GoalType;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */
public class GoalWebTypeByIdResolver extends TypeIdResolverBase {

    @Override
    public String idFromValue(Object value) {
        return null;
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return null;
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        final GoalType goalType = Goal.computeType(Long.valueOf(id));

        return SimpleType.constructUnsafe(goalType.isMetrika() || goalType.isDirect() ?
                MetrikaGoalWeb.class : CryptaGoalWeb.class);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

}
