package ru.yandex.direct.web.core.model.retargeting;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */
@ApiModel(parent = AbstractGoalWeb.class)
public class MetrikaGoalWeb extends AbstractGoalWeb {

    @JsonProperty("time")
    @ApiModelProperty(value = "при type == audience|segment поле не заполняется клиентом", required = true)
    private Integer time;

    @JsonProperty("allow_to_use")
    @ApiModelProperty(readOnly = true)
    private Boolean allowToUse;

    @JsonProperty("domain")
    @ApiModelProperty(readOnly = true)
    private String domain;

    @JsonProperty("owner")
    @ApiModelProperty(readOnly = true)
    private Long owner;

    @JsonProperty("counter_name")
    @ApiModelProperty(readOnly = true)
    private String counterName;

    @JsonProperty("counter_id")
    @ApiModelProperty(readOnly = true)
    private Integer counterId;

    @JsonProperty("subtype")
    @ApiModelProperty(readOnly = true)
    private String subtype;

    @JsonProperty("uploading_source_id")
    @ApiModelProperty(readOnly = true)
    private String uploadingSourceId;

    @JsonProperty("mobile_app_id")
    @ApiModelProperty(readOnly = true)
    private Long mobileAppId;

    @JsonProperty("mobile_app_name")
    @ApiModelProperty(readOnly = true)
    private String mobileAppName;

    public String getSubtype() {
        return subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public MetrikaGoalWeb withSubtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    public Integer getCounterId() {
        return counterId;
    }

    public void setCounterId(Integer counterId) {
        this.counterId = counterId;
    }

    public MetrikaGoalWeb withCounterId(Integer counterId) {
        this.counterId = counterId;
        return this;
    }

    public String getCounterName() {
        return counterName;
    }

    public void setCounterName(String counterName) {
        this.counterName = counterName;
    }

    public MetrikaGoalWeb withCounterName(String counterName) {
        this.counterName = counterName;
        return this;
    }

    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }

    public MetrikaGoalWeb withOwner(Long owner) {
        this.owner = owner;
        return this;
    }

    public MetrikaGoalWeb withType(WebGoalType type) {
        this.type = type;
        return this;
    }

    public Boolean getAllowToUse() {
        return allowToUse;
    }

    public void setAllowToUse(Boolean allowToUse) {
        this.allowToUse = allowToUse;
    }

    public MetrikaGoalWeb withAllowToUse(Boolean allowToUse) {
        this.allowToUse = allowToUse;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public MetrikaGoalWeb withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Integer getTime() {
        return time;
    }

    public void setTime(Integer time) {
        this.time = time;
    }

    public MetrikaGoalWeb withTime(Integer time) {
        this.time = time;
        return this;
    }

    public String getUploadingSourceId() {
        return uploadingSourceId;
    }

    public void setUploadingSourceId(String uploadingSourceId) {
        this.uploadingSourceId = uploadingSourceId;
    }

    public MetrikaGoalWeb withUploadingSourceId(String uploadingSourceId) {
        this.uploadingSourceId = uploadingSourceId;
        return this;
    }

    public MetrikaGoalWeb withId(Long id) {
        this.id = id;
        return this;
    }

    public MetrikaGoalWeb withName(String name) {
        this.name = name;
        return this;
    }

    public MetrikaGoalWeb withUnionWithId(Long unionWithId) {
        this.unionWithId = unionWithId;
        return this;
    }

    public Long getMobileAppId() {
        return mobileAppId;
    }

    public void setMobileAppId(Long mobileAppId) {
        this.mobileAppId = mobileAppId;
    }

    public MetrikaGoalWeb withMobileAppId(Long mobileAppId) {
        this.mobileAppId = mobileAppId;
        return this;
    }

    public String getMobileAppName() {
        return mobileAppName;
    }

    public void setMobileAppName(String mobileAppName) {
        this.mobileAppName = mobileAppName;
    }

    public MetrikaGoalWeb withMobileAppName(String mobileAppName) {
        this.mobileAppName = mobileAppName;
        return this;
    }
}
