package ru.yandex.direct.web.core.model.retargeting;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.GoalType;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition.DEFAULT_TYPE;
import static ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository.PROPERTY_INTEREST;
import static ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository.PROPERTY_NEGATIVE;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */
public class RetargetingConditionConverter {

    public static Goal toGoal(AbstractGoalWeb goalWeb) {
        Goal result = new Goal();
        result
                .withId(goalWeb.getId())
                .withUnionWithId(goalWeb.getUnionWithId());
        //поле computedGoalType нельзя задать явно; корректность преобразования надо проверять в вызывающем коде
        GoalType computedGoalType = result.getType();
        if ((computedGoalType.isMetrika() || computedGoalType.isDirect()) && computedGoalType != GoalType.AUDIENCE) {
            result.setTime(((MetrikaGoalWeb) goalWeb).getTime());
        }
        return result;
    }

    public static AbstractGoalWeb fromGoal(Goal goal) {
        if (!goal.getType().isCrypta()) {
            return new MetrikaGoalWeb()
                    .withId(goal.getId())
                    .withName(goal.getName())
                    .withType(WebGoalType.fromCoreType(goal.getType()))
                    .withSubtype(goal.getSubtype())
                    .withAllowToUse(goal.getAllowToUse())
                    .withOwner(goal.getOwner())
                    .withCounterId(goal.getCounterId())
                    .withCounterName(goal.getCounterName())
                    .withMobileAppId(goal.getMobileAppId())
                    .withMobileAppName(goal.getMobileAppName())
                    .withDomain(goal.getDomain())
                    .withUploadingSourceId(goal.getUploadingSourceId())
                    .withTime(goal.getTime())
                    .withUnionWithId(goal.getUnionWithId());
        } else {
            return new CryptaGoalWeb()
                    .withId(goal.getId())
                    .withName(goal.getName())
                    .withType(WebGoalType.fromCoreType(goal.getType()))
                    .withParentId(goal.getParentId());
        }
    }

    public static Condition fromRule(Rule rule) {
        return new Condition()
                .withConditionType(
                        rule.getType() != null ? RetargetingConditionRuleType
                                .valueOf(rule.getType().toString().toLowerCase()) : null)
                .withInterestType(CryptaInterestTypeWeb.fromCoreType(rule.getInterestType()))
                .withConditionGoalWebs(mapList(rule.getGoals(),
                        RetargetingConditionConverter::fromGoal));
    }


    private static Rule toRule(Condition cond) {
        List<Goal> goals = mapList(cond.getConditionGoalWebs(), RetargetingConditionConverter::toGoal);
        Rule rule = new Rule();
        rule
                .withType(cond.getConditionType() == null ? null : cond.getConditionType().getCoreMappedValue())
                .withInterestType(cond.getInterestType() == null ? null : cond.getInterestType().toCoreType())
                .withGoals(goals);
        return rule;
    }

    public static RetargetingCondition toRetargetingCondition(RetargetingConditionWeb condition, ClientId clientId) {
        List<Rule> rules;
        if (condition.getConditions() != null) {
            rules = new ArrayList<>();
            for (Condition cond : condition.getConditions()) {
                Rule rule = toRule(cond);
                rules.add(rule);
            }
        } else {
            rules = null;
        }
        RetargetingCondition retargetingCondition = new RetargetingCondition();
        retargetingCondition.withId(condition.getRetargetingConditionId())
                .withName(condition.getConditionName())
                .withType(condition.getType() == null ? DEFAULT_TYPE : condition.getType().getCoreMappedValue())
                .withDescription(condition.getConditionDescription())
                .withClientId(clientId.asLong())
                .withInterest(
                        condition.getProperties() != null && condition.getProperties().contains(PROPERTY_INTEREST))
                .withRules(rules);
        return retargetingCondition;
    }

    public static RetargetingConditionWeb fromRetargetingCondition(RetargetingCondition retargetingCondition) {
        return new RetargetingConditionWeb()
                .withClientId(retargetingCondition.getClientId())
                .withConditionDescription(retargetingCondition.getDescription())
                .withConditionName(retargetingCondition.getName())
                .withType(retargetingCondition.getType() == null ? null
                        : RetargetingConditionType.valueOf(retargetingCondition.getType().name().toLowerCase()))
                .withConditions(mapList(retargetingCondition.getRules(),
                        RetargetingConditionConverter::fromRule))
                .withIsAccessible(retargetingCondition.getAvailable() ? 1 : 0)
                .withProperties(getProperties(retargetingCondition))
                .withRetargetingConditionId(retargetingCondition.getId());
    }

    private static String getProperties(RetargetingCondition retargetingCondition) {
        String propertyNegative = retargetingCondition.getNegative() ? PROPERTY_NEGATIVE : null;
        String propertyInterest = retargetingCondition.getInterest() ? PROPERTY_INTEREST : null;
        String properties = StreamEx.of(propertyNegative, propertyInterest)
                .filter(Objects::nonNull)
                .joining(",");
        return properties.isEmpty() ? null : properties;
    }
}
