package ru.yandex.direct.web.core.model.retargeting;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.utils.FunctionalUtils;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class RetargetingConditionWeb {
    public static final String ID_FIELD_NAME = "id";
    public static final String NAME_FIELD_NAME = "name";
    public static final String TYPE_FIELD_NAME = "type";
    public static final String DESCRIPTION_FIELD_NAME = "description";
    public static final String CONDITIONS_FIELD_NAME = "conditions";
    public static final String PROPERTIES_FIELD_NAME = "properties";
    public static final String CLIENT_ID_FIELD_NAME = "client_id";
    public static final String IS_ACCESSIBLE_FIELD_NAME = "is_accessible";

    @JsonProperty(ID_FIELD_NAME)
    @ApiModelProperty("При сохранении необходимо оставить пустым. При апдейте является обязательным")
    private Long retargetingConditionId;

    @JsonProperty(NAME_FIELD_NAME)
    @ApiModelProperty(required = true)
    private String conditionName;

    @JsonProperty(TYPE_FIELD_NAME)
    @ApiModelProperty(required = true)
    private RetargetingConditionType type;

    @JsonProperty(DESCRIPTION_FIELD_NAME)
    private String conditionDescription;

    @JsonProperty(CONDITIONS_FIELD_NAME)
    @ApiModelProperty(required = true)
    private List<Condition> conditions;

    //заполняется для результирующего JSON
    @JsonProperty(PROPERTIES_FIELD_NAME)
    @ApiModelProperty(readOnly = true)
    private String properties;

    //заполняется для результирующего JSON
    @JsonProperty(CLIENT_ID_FIELD_NAME)
    @ApiModelProperty(readOnly = true)
    private long clientId;

    //заполняется для результирующего JSON
    @JsonProperty(IS_ACCESSIBLE_FIELD_NAME)
    @ApiModelProperty(readOnly = true)
    private int isAccessible;

    private static Rule toRule(Condition cond) {
        List<Goal> goals =
                FunctionalUtils.mapList(cond.getConditionGoalWebs(), RetargetingConditionConverter::toGoal);
        Rule rule = new Rule();
        rule.withType(cond.getConditionType() == null ? null
                : cond.getConditionType().getCoreMappedValue())
                .withGoals(goals);
        return rule;
    }

    public Long getRetargetingConditionId() {
        return retargetingConditionId;
    }

    public void setRetargetingConditionId(Long retargetingConditionId) {
        this.retargetingConditionId = retargetingConditionId;
    }

    public RetargetingConditionWeb withRetargetingConditionId(Long retargetingConditionId) {
        this.retargetingConditionId = retargetingConditionId;
        return this;
    }

    public String getConditionName() {
        return conditionName;
    }

    public void setConditionName(String conditionName) {
        this.conditionName = conditionName;
    }

    public RetargetingConditionWeb withConditionName(String conditionName) {
        this.conditionName = conditionName;
        return this;
    }

    public RetargetingConditionType getType() {
        return type;
    }

    public void setType(RetargetingConditionType type) {
        this.type = type;
    }

    public RetargetingConditionWeb withType(RetargetingConditionType type) {
        this.type = type;
        return this;
    }

    public String getConditionDescription() {
        return conditionDescription;
    }

    public void setConditionDescription(String conditionDescription) {
        this.conditionDescription = conditionDescription;
    }

    public RetargetingConditionWeb withConditionDescription(String conditionDescription) {
        this.conditionDescription = conditionDescription;
        return this;
    }

    public List<Condition> getConditions() {
        return conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public RetargetingConditionWeb withConditions(
            List<Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public String getProperties() {
        return properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public RetargetingConditionWeb withProperties(String properties) {
        this.properties = properties;
        return this;
    }

    public RetargetingConditionWeb withClientId(long clientId) {
        this.clientId = clientId;
        return this;
    }

    public RetargetingConditionWeb withIsAccessible(int isAccessible) {
        this.isAccessible = isAccessible;
        return this;
    }

    public RetargetingCondition toRetargetingCondition(ClientId clientId) {
        List<Rule> rules = new ArrayList<>();
        if (conditions != null) {
            for (Condition cond : conditions) {
                Rule rule = toRule(cond);
                rules.add(rule);
            }
        }
        RetargetingCondition retargetingCondition = new RetargetingCondition();
        retargetingCondition.withId(retargetingConditionId)
                .withName(conditionName)
                .withDescription(conditionDescription)
                .withClientId(clientId.asLong())
                .withRules(rules);
        return retargetingCondition;

    }
}
