package ru.yandex.direct.web.core.model.retargeting;

import java.util.Map;
import java.util.function.Function;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonValue;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.retargeting.model.GoalType;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.AB_SEGMENT;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.AUDIENCE;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.AUDIO_GENRES;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.BEHAVIORS;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.BRANDSAFETY;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.CDP_SEGMENT;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.CONTENT_CATEGORY;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.CONTENT_GENRE;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.FAMILY;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.GOAL;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.HOST;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.INTERESTS;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.INTERNAL;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.LAL_SEGMENT;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.MOBILE;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.SEGMENT;
import static ru.yandex.direct.core.entity.retargeting.model.GoalType.SOCIAL_DEMO;

/**
 * TODO: после удаления RetargetingController из intapi нужно перенести все эти модели в web
 */
public enum WebGoalType {
    goal(GOAL, "goal"),

    segment(SEGMENT, "segment"),

    lal_segment(LAL_SEGMENT, "lal_segment"),

    ecommerce(GoalType.ECOMMERCE, "ecommerce"),

    audience(AUDIENCE, "audience"),

    social_demo(SOCIAL_DEMO, "social_demo"),

    family(FAMILY, "family"),

    interests(INTERESTS, "interests"),

    ab_segment(AB_SEGMENT, "ab_segment"),

    cdp_segment(CDP_SEGMENT, "cdp_segment"),

    behaviors(BEHAVIORS, "behaviors"),

    internal(INTERNAL, "internal"),

    audio_genres(AUDIO_GENRES, "audio_genres"),

    brandsafety(BRANDSAFETY, "brandsafety"),

    content_category(CONTENT_CATEGORY, "content_category"),

    content_genre(CONTENT_GENRE, "content_genre"),

    host(HOST, "host"),

    mobile(MOBILE, "mobile");

    private static final Map<String, WebGoalType> ENUM_MAP = StreamEx.of(values())
            .mapToEntry(x -> x.text, Function.identity())
            .toMap();


    private final GoalType coreType;
    private final String text;

    WebGoalType(GoalType coreType, String text) {
        this.coreType = coreType;
        this.text = text;
    }

    @Nonnull
    public static WebGoalType fromString(String value) {
        checkNotNull(value);

        checkArgument(ENUM_MAP.containsKey(value), "No such enum value: {}", value);
        return ENUM_MAP.get(value);
    }

    public static WebGoalType fromCoreType(GoalType goalType) {
        return fromString(goalType.toString().toLowerCase());
    }

    public GoalType toCoreType() {
        return coreType;
    }

    @Override
    @JsonValue
    public String toString() {
        return text;
    }
}
