package ru.yandex.direct.web.core.security;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.rbac.RbacRole;
import ru.yandex.direct.web.auth.blackbox.BlackboxCookieAuth;
import ru.yandex.direct.web.core.security.authentication.exception.DirectAuthenticationServiceException;

import static ru.yandex.direct.web.core.security.authentication.AuthenticationErrorCodes.AUTHENTICATION_SERVICE_ERROR;
import static ru.yandex.direct.web.core.security.authentication.WebAuthTranslations.WEB_AUTH_TRANSLATIONS;

// имя должно быть зафиксировано для правильного переопределения в тестовой конфигурации
@Service(DirectWebAuthenticationSource.BEAN_NAME)
public class DirectWebAuthenticationSource {

    public static final String BEAN_NAME = "directWebAuthenticationSource";

    /**
     * Типизированный ({@link DirectAuthentication}) wrapper над {@link SecurityContextHolder#getContext()}
     * ({@link  org.springframework.security.core.context.SecurityContext#getAuthentication} only)
     */
    public DirectAuthentication getAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof DirectAuthentication) {
            return (DirectAuthentication) authentication;
        }
        if (authentication instanceof BlackboxCookieAuth) {
            BlackboxCookieAuth blackboxCookieAuth = (BlackboxCookieAuth) authentication;
            User operator = new User()
                    .withLogin(blackboxCookieAuth.getPrincipal())
                    .withUid(blackboxCookieAuth.getUid())
                    .withRole(RbacRole.EMPTY);
            return new DirectAuthentication(operator, null, blackboxCookieAuth.getTvmUserTicket(), null);
        }
        throw new DirectAuthenticationServiceException("DirectWebAuthenticationSource cannot return authentication",
                AUTHENTICATION_SERVICE_ERROR, WEB_AUTH_TRANSLATIONS.authenticationServiceUnavailable(), null);
    }

    /**
     * Аутентифицирован ли пользователь
     */
    public boolean isAuthenticated() {
        return SecurityContextHolder.getContext().getAuthentication() != null;
    }
}
