package ru.yandex.direct.web.core.security.authentication;

import java.net.InetAddress;

import org.apache.commons.lang3.StringUtils;

/**
 * Инкапсулирует параметры авторизации, специфичные для Директа. Нужен в тестах, чтобы мокать было удобней.
 */
class DirectWebAuthRequest {
    private final String ulogin;
    private final Long clientUid;
    private final InetAddress clientAddress;

    public DirectWebAuthRequest(InetAddress clientAddress, String ulogin, Long clientUid) {
        this.clientAddress = clientAddress;
        this.ulogin = StringUtils.trimToNull(ulogin);
        this.clientUid = clientUid;
    }

    public String getUlogin() {
        return ulogin;
    }

    public Long getClientUid() {
        return clientUid;
    }

    public InetAddress getClientAddress() {
        return clientAddress;
    }
}
