package ru.yandex.direct.web.core.security.authentication;

import java.io.Serializable;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

import static ru.yandex.direct.web.core.security.authentication.DirectCookieAuthProvider.PARAMETER_CLIENT_UID;

public interface WebAuthTranslations extends TranslationBundle, Serializable {
    WebAuthTranslations WEB_AUTH_TRANSLATIONS = I18NBundle.implement(WebAuthTranslations.class);

    @TranslationStub("Сервис аутентификации временно недоступен")
    Translatable authenticationServiceUnavailable();

    @TranslationStub("Не указан клиент")
    Translatable clientIsNotSpecified();

    @TranslationStub("Пдд-пользователям доступ ограничен")
    Translatable accessDeniedForPDDUsers();

    @TranslationStub("Пользователь не найден")
    Translatable userNotFound();

    @MessageFormatStub("Не наден пользователь с uid {0}")
    Translatable uidNotFound(Long uid);

    @MessageFormatStub("Неверный формат поля " + PARAMETER_CLIENT_UID + " {0}")
    Translatable uidFormatError(String uid);

    @TranslationStub("Доступ возможен только из внутренней сети Яндекса")
    Translatable onlyForInternalNetwork();

    @TranslationStub("Требуется заполнить недостающие регистрационные данные")
    Translatable registrationDataAbsent();

    @TranslationStub("Неверные аутентификационные данные")
    Translatable badCredentials();

    @TranslationStub("Истек срок действия сессии")
    Translatable credentialsHasExpired();
}
