package ru.yandex.direct.web.core.security.authentication.exception;

import ru.yandex.direct.core.TranslatableException;
import ru.yandex.direct.i18n.Translatable;

/**
 * Используется как базовый класс исключений аутентификации.
 * Стандартные исключения спринга переводятся в соответствующих наследников.
 */
public class TranslatableAuthenticationException extends TranslatableException {
    public TranslatableAuthenticationException(String internalDescription, Throwable cause, int code,
                                               Translatable shortMessage, Translatable detailedMessage) {
        super(internalDescription, cause, code, shortMessage, detailedMessage);
    }

    public TranslatableAuthenticationException(String internalDescription, int code, Translatable shortMessage,
                                               Translatable detailedMessage) {
        super(internalDescription, code, shortMessage, detailedMessage);
    }

    public TranslatableAuthenticationException(Throwable cause, int code, Translatable shortMessage,
                                               Translatable detailedMessage) {
        super(cause, code, shortMessage, detailedMessage);
    }

    public TranslatableAuthenticationException(int code, Translatable shortMessage, Translatable detailedMessage) {
        super(code, shortMessage, detailedMessage);
    }
}
