package ru.yandex.direct.web.core.security.captcha;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.env.EnvironmentType;

public class CaptchaFirewallInterceptorConfig {
    private final String captchaSolvingPageUrl;
    private final long autobanCaptchaFreq;
    private final EnvironmentType env;
    private final List<Pair<Long, Long>> karmaLimits;
    private final String redisKeyPrefix;

    public CaptchaFirewallInterceptorConfig(
            String captchaSolvingPageUrl,
            long autobanCaptchaFreq,
            DirectConfig directConfig,
            EnvironmentType env,
            String redisKeyPrefix) {
        this.captchaSolvingPageUrl = captchaSolvingPageUrl;
        this.autobanCaptchaFreq = autobanCaptchaFreq;
        this.env = env;
        this.karmaLimits = ImmutableList.copyOf(createKarmaLimits(directConfig));
        this.redisKeyPrefix = redisKeyPrefix;
    }

    private static List<Pair<Long, Long>> createKarmaLimits(DirectConfig directConfig) {
        DirectConfig conf = directConfig.getBranch("direct_captcha");
        List<DirectConfig> limitsObject = conf.getConfigList("karma_limits");
        List<Pair<Long, Long>> result = new ArrayList<>(limitsObject.size());
        for (DirectConfig pointConfig : limitsObject) {
            long x = pointConfig.getLong("x");
            long y = pointConfig.getLong("y");
            result.add(Pair.of(x, y));
        }
        result.sort(Comparator.comparingLong(Pair::getLeft));
        return result;
    }

    public String getCaptchaSolvingPageUrl() {
        return captchaSolvingPageUrl;
    }

    public long getAutobanCaptchaFreq() {
        return autobanCaptchaFreq;
    }

    public EnvironmentType getEnv() {
        return env;
    }

    public List<Pair<Long, Long>> getKarmaLimits() {
        return karmaLimits;
    }

    public String getRedisKeyPrefix() {
        return redisKeyPrefix;
    }
}
