package ru.yandex.direct.web.core.security.captcha;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Параметры срабатывания капчи.
 * <p>
 * За {@link #interval()} секунд пользователь может совершить {@link #maxFreq()} запросов,
 * после этого начинаем показывать капчу на каждый {@link #freq()} запрос.
 * Если указан {@link #increment()}, то каждый запрос считается за N запросов (по умолчанию N=1)
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface CaptchaLimits {
    int freq();

    int interval();

    int maxFreq();

    int increment() default 1;
}
