package ru.yandex.direct.web.core.security.captcha;


/**
 * Параметры срабатывания капчи.
 *
 * @see {@link CaptchaLimits}
 */
public class CaptchaLimitsParams {
    private final int freq;
    private final int interval;
    private final int maxFreq;
    private final int increment;


    public CaptchaLimitsParams(int freq, int interval, int maxFreq, int increment) {
        this.freq = freq;
        this.interval = interval;
        this.maxFreq = maxFreq;
        this.increment = increment;
    }

    public CaptchaLimitsParams(int freq, int interval, int maxFreq) {
        this(freq, interval, maxFreq, 1);
    }

    public static CaptchaLimitsParams fromCaptchaLimits(CaptchaLimits limits) {
        return new CaptchaLimitsParams(limits.freq(), limits.interval(), limits.maxFreq(), limits.increment());
    }

    public int getFreq() {
        return freq;
    }

    public int getInterval() {
        return interval;
    }

    public int getMaxFreq() {
        return maxFreq;
    }

    public int getIncrement() {
        return increment;
    }
}
