package ru.yandex.direct.web.core.security.captcha;

/**
 * Позволяет абстрагироваться от способов срабатывания капчи.
 * Капча может сработать при различных условиях, и, что самое главное - параметры(лимиты) капчи при этом будут различными.
 * Однако {@link  CaptchaChecker}'у не обязательно знать о том, как появилась капча.
 */
public class CaptchaParams {
    /**
     * Тип запроса. Обычно его значение равно первому элементу из
     * {@link org.springframework.web.bind.annotation.RequestMapping#path()}
     */
    private final String requestType;

    /**
     * Ключ(id) запроса. Обычно зависит от UID и/или IP клиента.
     */
    private final String requestKey;

    /**
     * Пределы срабатывания капчи.
     */
    private final CaptchaLimitsParams captchaLimits;

    public CaptchaParams(String requestType, String requestKey, CaptchaLimitsParams captchaLimits) {
        this.requestType = requestType;
        this.requestKey = requestKey;
        this.captchaLimits = captchaLimits;
    }

    public String getRequestType() {
        return requestType;
    }

    public String getRequestKey() {
        return requestKey;
    }

    public CaptchaLimitsParams getCaptchaLimits() {
        return captchaLimits;
    }
}
