package ru.yandex.direct.web.core.security.captcha;

import java.util.ArrayList;
import java.util.List;

import com.google.common.base.Preconditions;


/**
 * Агрегированный CaptchaChecker; инкапсулирует несколько CaptchaChecker'ов
 */
class CombinedCaptchaChecker implements CaptchaChecker {
    private final List<CaptchaChecker> captchaCheckers;
    private List<CaptchaChecker> needsCaptchaSolving;

    CombinedCaptchaChecker(List<CaptchaChecker> captchaCheckers) {
        this.captchaCheckers = captchaCheckers;
    }

    /**
     * @return true, если хотя бы один из подчиненных {@link #captchaCheckers} рапортует о превышении числа запросов.
     */
    @Override
    public boolean onUserRequest() {
        needsCaptchaSolving = new ArrayList<>();
        for (CaptchaChecker checker : captchaCheckers) {
            if (checker.onUserRequest()) {
                needsCaptchaSolving.add(checker);
            }
        }
        return !needsCaptchaSolving.isEmpty();
    }

    /**
     * Информирует {@link #captchaCheckers} о успешном распознавании капчи. Информируются только CaptchaCheckers,
     * запросившие проверку при вызове {@link #onUserRequest()}
     */
    @Override
    public void onRecognition() {
        Preconditions.checkNotNull(needsCaptchaSolving);
        for (CaptchaChecker checker : needsCaptchaSolving) {
            checker.onRecognition();
        }
        needsCaptchaSolving = null;
    }
}
