package ru.yandex.direct.web.core.security.captcha;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

class Interpolator {
    private Interpolator() {
    }

    public static <T extends Comparable<T>> T interpolateConst(List<Pair<T, T>> functionPoints, T x) {
        int pointIndex = Collections.binarySearch(functionPoints, Pair.of(x, null),
                Comparator.comparing(Pair::getLeft));
        if (pointIndex >= 0) {
            return functionPoints.get(pointIndex).getRight();
        } else {
            int insertionPoint = -pointIndex - 1;
            int resultIndex = insertionPoint == 0 ? 0 : insertionPoint - 1;
            return functionPoints.get(resultIndex).getRight();
        }
    }
}
