package ru.yandex.direct.web.core.security.configuration;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.common.configuration.CommonConfiguration;
import ru.yandex.direct.common.net.NetAcl;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.web.core.security.netacl.NetAclInterceptor;

@Configuration
@ComponentScan(
        basePackages = "ru.yandex.direct.web.core.security.netacl",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@Import({CommonConfiguration.class})
public class NetAclConfiguration {

    public static final String NET_ACL_ALWAYS_ALLOW_NETWORKS = "netacl_always_allow_networks";

    @Autowired
    private NetAcl netAcl;

    @Autowired
    private EnvironmentType env;

    @Autowired
    private DirectConfig directConfig;

    @Bean
    public NetAclInterceptor netAclInterceptor() {
        List<String> networkConfig = directConfig.getStringList(NET_ACL_ALWAYS_ALLOW_NETWORKS);
        return new NetAclInterceptor(netAcl, env, networkConfig);
    }
}
