package ru.yandex.direct.web.core.security.csrf;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Указывает, нужно ли делать проверку csrf токена
 * для POST запорсов, если аннотация не указана, то по умолчанию делается проверка
 * для GET запросов, если аннотация не указана, то по умолчанию проверка не делается
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface CsrfCheck {
    boolean enabled();
}
