package ru.yandex.direct.web.core.security.netacl;


import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import ru.yandex.direct.common.net.NetworkName;

/**
 * Разрешает(на основании IP) доступ к методу клиентам, входящим в сети из {@link AllowNetworks#value()}
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface AllowNetworks {
    NetworkName[] value();
}
