package ru.yandex.direct.web.core.security.tvm;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.core.security.AccessDeniedException;
import ru.yandex.direct.core.security.SecurityTranslations;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.tvm.AbstractTvmInterceptor;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;

/**
 * Реализация {@link AbstractTvmInterceptor} для web-контроллеров
 */
public class TvmInterceptor extends AbstractTvmInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TvmInterceptor.class);

    public TvmInterceptor(TvmIntegration tvmIntegration, EnvironmentType environmentType) {
        super(tvmIntegration, environmentType);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Exception accessDeniedExceptionInvalidTvmTicket(Exception cause) {
        return new AccessDeniedException("Invalid tvm service ticket", cause);
    }

    @Override
    protected Exception accessDeniedExceptionInvalidUserTicket(Exception cause) {
        return new AccessDeniedException("Invalid user ticket", cause);
    }

    @Override
    protected Exception accessDeniedExceptionNoTvmTicket() {
        return new AccessDeniedException("Не передан TVM тикет");
    }

    @Override
    protected Exception sourceApplicationAccessDeniedException(TvmService sourceService) {
        return new AccessDeniedException(
                String.format("Приложению %s не разрешен доступ", sourceService),
                SecurityTranslations.INSTANCE.accessDenied());
    }
}
