package ru.yandex.direct.ydb.tvm;

import com.yandex.ydb.core.auth.AuthProvider;

import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;

import static com.yandex.ydb.auth.tvm.YdbClientId.YDB;

public class YdbTvmAuthProvider implements AuthProvider {

    private final TvmIntegration tvmIntegration;
    private final TvmService tvmService;

    public YdbTvmAuthProvider(TvmIntegration tvmIntegration) {
        this.tvmIntegration = tvmIntegration;
        this.tvmService = TvmService.fromIdStrict(YDB.getId());
    }

    @Override
    public String getToken() {
        return tvmIntegration.getTicket(tvmService);
    }

    /**
     * tvmIntegration передается извне, поэтому и закрываться должен извне, поэтому метод пустой
     */
    @Override
    public void close() {

    }
}
