package ru.yandex.direct.ytcomponents.config;

import java.time.Duration;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ytwrapper.model.YtCluster;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class BrandSurveyStatusDynConfig {
    private final String brandSurveyStatusTablePath;
    private final Collection<YtCluster> clusters;
    private final Duration clusterRefreshInterval;
    private final Duration selectRowsTimeout;

    public BrandSurveyStatusDynConfig(DirectConfig directConfig) {
        var config = directConfig.getBranch("brand_survey");
        this.brandSurveyStatusTablePath = config.getString("status_table_path");
        this.clusters = mapList(config.getStringList("clusters"), YtCluster::parse);
        this.clusterRefreshInterval = Duration.ofSeconds(config.getLong("cluster_refresh_period"));
        this.selectRowsTimeout = Duration.ofSeconds(config.getLong("select_rows_timeout"));
    }

    public String getBrandSurveyStatusTablePath() {
        return brandSurveyStatusTablePath;
    }

    public Collection<YtCluster> getClusters() {
        return clusters;
    }

    public Duration getClusterRefreshInterval() {
        return clusterRefreshInterval;
    }

    public Duration getSelectRowsTimeout() {
        return selectRowsTimeout;
    }
}
