package ru.yandex.direct.ytcomponents.config;

import java.time.Duration;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.ytwrapper.YtPathUtil;
import ru.yandex.direct.ytwrapper.model.YtCluster;

public class BsExportYtDynConfig {

    private final String tablesPath;
    private final YtCluster cluster;
    private final Duration transactionTimeout;
    private final int queueBatchSize;
    private final int queueBatchSizeKilobytes;
    private final DirectConfig config;

    public BsExportYtDynConfig(DirectConfig config) {
        this.tablesPath = config.getString("path");
        this.cluster = YtCluster.parse(config.getString("cluster"));
        this.transactionTimeout = config.getDuration("transaction_timeout");
        this.queueBatchSize = config.getInt("queue_batch_size");
        this.queueBatchSizeKilobytes = config.getInt("queue_batch_size_kilobytes");
        this.config = config;
    }


    public YtCluster getCluster() {
        return cluster;
    }

    public String getAbsoluteTablePath(String tableName) {
        return YtPathUtil.generatePath(tablesPath, tableName);
    }

    public String getAbsoluteQueuePath(String tableName) {
        return YtPathUtil.generatePath(tablesPath, "queues", tableName + "Queue", "queue");
    }

    public Duration getTransactionTimeout() {
        return transactionTimeout;
    }

    public int getQueueBatchSize() {
        return queueBatchSize;
    }

    public String getAdGroupsTable() {
        return getAbsoluteTablePath(config.getString("adgroups"));
    }

    public String getAdGroupsQueue() {
        return getAbsoluteQueuePath(config.getString("adgroups"));
    }

    public String getAdGroupShowConditionsTable() {
        return getAbsoluteTablePath(config.getString("adgroup-show-conditions"));
    }

    public String getAdGroupShowConditionsQueue() {
        return getAbsoluteQueuePath(config.getString("adgroup-show-conditions"));
    }

    public String getBannerResourcesTable() {
        return getAbsoluteTablePath(config.getString("banner-resources"));
    }

    public String getBannerResourcesQueue() {
        return getAbsoluteQueuePath(config.getString("banner-resources"));
    }

    public String getMultipliersTable() {
        return getAbsoluteTablePath(config.getString("multipliers"));
    }

    public String getMultipliersQueue() {
        return getAbsoluteQueuePath(config.getString("multipliers"));
    }

    public String getCampaignsTable() {
        return getAbsoluteTablePath(config.getString("campaigns"));
    }

    public String getCampaignsQueue() {
        return getAbsoluteQueuePath(config.getString("campaigns"));
    }

    public String getStrategiesTable() {
        return getAbsoluteTablePath(config.getString("strategies"));
    }

    public String getStrategiesQueue() {
        return getAbsoluteQueuePath(config.getString("strategies"));
    }

    public String getFeedsTable() {
        return getAbsoluteTablePath(config.getString("feeds"));
    }

    public String getFeedsAccessTable() {
        return getAbsoluteTablePath(config.getString("feeds-access"));
    }

    public String getBidsTable() {
        return getAbsoluteTablePath(config.getString("bids"));
    }

    public String getBiddableShowConditionsTable() {
        return getAbsoluteTablePath(config.getString("biddable-show-conditions"));
    }

    public String getBiddableShowConditionsQueue() {
        return getAbsoluteQueuePath(config.getString("biddable-show-conditions"));
    }

    public String getDspCreativeTable() {
        return getAbsoluteTablePath(config.getString("dsp-creative"));
    }

    public String getDspCreativeQueue() {
        return getAbsoluteQueuePath(config.getString("dsp-creative"));
    }

    public String getMobileGoalsExternalTrackerTable() {
        return getAbsoluteTablePath(config.getString("mobile-goals-external-tracker"));
    }

    public int getQueueBatchSizeKilobytes() {
        return queueBatchSizeKilobytes;
    }

    public String getDirectMeaningfulGoalsTable() {
        return getAbsoluteTablePath(config.getString("meaningful-goals"));
    }

    public String getDirectMetrikaCountersTable() {
        return getAbsoluteTablePath(config.getString("metrika-counters"));
    }

}
