package ru.yandex.direct.ytcomponents.config;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import org.jooq.Table;
import org.springframework.stereotype.Component;

import ru.yandex.direct.ytwrapper.dynamic.TableMappings;

import static ru.yandex.direct.grid.schema.yt.Tables.ALL_COUNTERS_BY_DOMAIN;
import static ru.yandex.direct.grid.schema.yt.Tables.ASSETSSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.BANNERSTABLE_DIRECT;
import static ru.yandex.direct.grid.schema.yt.Tables.BIDSTABLE_DIRECT;
import static ru.yandex.direct.grid.schema.yt.Tables.BIDS_RETARGETINGTABLE_DIRECT;
import static ru.yandex.direct.grid.schema.yt.Tables.BRANDLIFT_SURVEYS;
import static ru.yandex.direct.grid.schema.yt.Tables.BRANDSAFETYCATEGORYSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.BRANDSAFETYFILTRATIONS_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.BRANDSAFETYSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.CAESARORDERINFO_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.CALLTRACKING_NUMBER_CLICKS;
import static ru.yandex.direct.grid.schema.yt.Tables.CALLTRACKING_PHONE_WITHOUT_REPLACEMENTS;
import static ru.yandex.direct.grid.schema.yt.Tables.CAMPAIGNSTABLE_DIRECT;
import static ru.yandex.direct.grid.schema.yt.Tables.CATEGORIES_BLOCKED_DOMAINS;
import static ru.yandex.direct.grid.schema.yt.Tables.COMMUNICATIONSCHANNEL;
import static ru.yandex.direct.grid.schema.yt.Tables.CONV_MAIN_AD_GOALS;
import static ru.yandex.direct.grid.schema.yt.Tables.CONV_MAIN_COUNTERS;
import static ru.yandex.direct.grid.schema.yt.Tables.COUNTERS_BY_DOMAIN_HIT_LOG;
import static ru.yandex.direct.grid.schema.yt.Tables.COUNTER_BY_DOMAIN;
import static ru.yandex.direct.grid.schema.yt.Tables.CURRENCY_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.CURRENT_RECOMMENDATIONS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTCONVERSIONCOST_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTGRIDGOALSSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTGRIDSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTMOBILEAPPSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTMOBILEEVENTSSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTPHRASEGOALSSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTPHRASESTATV2_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECT_GRID_MYSQL_SYNC_STATES;
import static ru.yandex.direct.grid.schema.yt.Tables.EVENTCONFIGURATION;
import static ru.yandex.direct.grid.schema.yt.Tables.EVENTVERSIONCONFIGURATION;
import static ru.yandex.direct.grid.schema.yt.Tables.EXTERNAL_CALLTRACKING_BY_DOMAIN;
import static ru.yandex.direct.grid.schema.yt.Tables.FEED_TO_TASKS_DYN;
import static ru.yandex.direct.grid.schema.yt.Tables.FEED_TO_TASKS_PERF;
import static ru.yandex.direct.grid.schema.yt.Tables.IMPORT_FROM_BNO_SITELINKS;
import static ru.yandex.direct.grid.schema.yt.Tables.OFFERATTRIBUTES_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.OFFERSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.ORDERSTATDAY_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.ORDERSTATFRAUD_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.ORDERSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.PHRASEIDBYDATAMD5_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.PHRASESTABLE_DIRECT;
import static ru.yandex.direct.grid.schema.yt.Tables.RECOMMENDATIONS_STATUSTABLE_DIRECT;
import static ru.yandex.direct.grid.schema.yt.Tables.RETARGETING_CONDITIONSTABLE_DIRECT;
import static ru.yandex.direct.grid.schema.yt.Tables.SUGGEST_CONVERSION_PRICE;
import static ru.yandex.direct.grid.schema.yt.Tables.TAXHISTORY_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.TEST_BSEXPORT_TEST_LOGS;
import static ru.yandex.direct.grid.schema.yt.Tables.WHITELIST_CATEGORIES;

/**
 * {@link TableMappings} с описанием динтаблиц YT, используемых в Директе.
 */
@Component
public class DirectDynTablesMapping implements TableMappings {

    private final Map<Table<?>, String> tableMappings;

    public DirectDynTablesMapping(DirectYtDynamicConfig config) {
        tableMappings = extractPaths(config);
    }

    @Override
    public Map<Table<?>, String> getTableMappings() {
        return tableMappings;
    }

    private static Map<Table<?>, String> extractPaths(DirectYtDynamicConfig config) {
        return ImmutableMap.<Table<?>, String>builder()
                .put(DIRECT_GRID_MYSQL_SYNC_STATES, config.tables().direct().syncStatesTablePath())
                .put(PHRASESTABLE_DIRECT, config.tables().direct().phrasesTablePath())
                .put(BANNERSTABLE_DIRECT, config.tables().direct().bannersTablePath())
                .put(BIDSTABLE_DIRECT, config.tables().direct().bidsTablePath())
                .put(BIDS_RETARGETINGTABLE_DIRECT, config.tables().direct().bidsRetargetingTablePath())
                .put(CAMPAIGNSTABLE_DIRECT, config.tables().direct().campaignsTablePath())
                .put(RETARGETING_CONDITIONSTABLE_DIRECT, config.tables().direct().retargetingConditionsTablePath())
                .put(DIRECTPHRASESTATV2_BS, config.tables().yabsStat().phrasesTablePath())
                .put(DIRECTGRIDSTAT_BS, config.tables().yabsStat().ordersTablePath())
                .put(ORDERSTATDAY_BS, config.tables().yabsStat().orderStatDayTablePath())
                .put(ORDERSTATFRAUD_BS, config.tables().yabsStat().orderStatFraudTablePath())
                .put(DIRECTCONVERSIONCOST_BS, config.tables().yabsStat().conversionsTablePath())
                .put(TAXHISTORY_BS, config.tables().yabsStat().taxHistoryTablePath())
                .put(DIRECTPHRASEGOALSSTAT_BS, config.tables().yabsStat().phraseGoalsTablePath())
                .put(DIRECTGRIDGOALSSTAT_BS, config.tables().yabsStat().orderGoalsTablePath())
                .put(BRANDSAFETYFILTRATIONS_BS, config.tables().yabsStat().brandSafetyFiltrationsTablePath())
                .put(BRANDSAFETYSTAT_BS, config.tables().yabsStat().brandSafetyStatTablePath())
                .put(BRANDSAFETYCATEGORYSTAT_BS, config.tables().yabsStat().brandSafetyCategoryStatTablePath())
                .put(DIRECTMOBILEAPPSTAT_BS, config.tables().yabsStat().mobileAppStatTablePath())
                .put(DIRECTMOBILEEVENTSSTAT_BS, config.tables().yabsStat().mobileEventsStatTablePath())
                .put(CURRENT_RECOMMENDATIONS, config.tables().recommendations().recommendationsTablePath())
                .put(RECOMMENDATIONS_STATUSTABLE_DIRECT, config.tables().direct().recommendationsStatusTablePath())
                .put(ORDERSTAT_BS, config.tables().yabsStat().orderStatTablePath())
                .put(CAESARORDERINFO_BS, config.tables().yabsDict().orderInfoDictTablePath())
                .put(PHRASEIDBYDATAMD5_BS, config.tables().yabsDict().oldPhraseIdsTablePath())
                .put(CURRENCY_BS, config.tables().yabsDict().currencyDictTablePath())
                .put(TEST_BSEXPORT_TEST_LOGS, config.tables().direct().bsExportlogsTablePath())
                .put(BRANDLIFT_SURVEYS, config.tables().direct().brandSurveysTablePath())
                .put(WHITELIST_CATEGORIES, config.tables().direct().categoriesWhitelistTablePath())
                .put(CATEGORIES_BLOCKED_DOMAINS, config.tables().direct().categoriesBlockedDomainsTablePath())
                .put(COUNTER_BY_DOMAIN, config.tables().direct().counterByDomainTablePath())
                .put(ALL_COUNTERS_BY_DOMAIN, config.tables().direct().allCountersByDomainTablePath())
                .put(COUNTERS_BY_DOMAIN_HIT_LOG, config.tables().direct().countersByDomainHitLogTablePath())
                .put(IMPORT_FROM_BNO_SITELINKS, config.tables().sitelinks().sitelinksImportTablePath())
                .put(CALLTRACKING_NUMBER_CLICKS, config.tables().direct().calltrackingNumberClicksTablePath())
                .put(CALLTRACKING_PHONE_WITHOUT_REPLACEMENTS,
                        config.tables().direct().calltrackingPhonesWithoutReplacementsTablePath())
                .put(EXTERNAL_CALLTRACKING_BY_DOMAIN, config.tables().direct().calltrackingExternalByDomainTablePath())
                .put(COMMUNICATIONSCHANNEL, config.tables().communicationPlatform().messagesTablePath())
                .put(EVENTCONFIGURATION, config.tables().communicationPlatform().eventConfigTablePath())
                .put(EVENTVERSIONCONFIGURATION, config.tables().communicationPlatform().eventVersionConfigTablePath())
                .put(SUGGEST_CONVERSION_PRICE, config.tables().direct().suggestConversionPriceTablePath())
                .put(CONV_MAIN_AD_GOALS, config.tables().metrikaConvAdGoals().metrikaConvAdGoalsTablePath())
                .put(ASSETSSTAT_BS, config.tables().yabsStat().assetsStatTablePath())
                .put(OFFERSTAT_BS, config.tables().yabsStat().offerStatTablePath())
                .put(OFFERATTRIBUTES_BS, config.tables().yabsStat().offerAttributesTablePath())
                .put(FEED_TO_TASKS_DYN, config.tables().blrt().dynFeedToTasksTablePath())
                .put(FEED_TO_TASKS_PERF, config.tables().blrt().perfFeedToTasksTablePath())
                .put(CONV_MAIN_COUNTERS, config.tables().convMainCountersTables().convMainCountersTablePath())
                //TODO-buhter: add tag-group mapping DIRECT-81631
                .build();
    }
}
