package ru.yandex.direct.ytcomponents.config;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import org.jooq.Table;

import ru.yandex.direct.ytwrapper.dynamic.TableMappings;

import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTGRIDGOALSSTAT_BS;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTGRIDSTAT_BS;

/**
 * Component to override Yt-tables-to-path mapping in runtime for test purposes
 */
public class DirectDynTestTablesMapping implements TableMappings {

    private final Map<Table<?>, String> tableMappings;

    public DirectDynTestTablesMapping(DirectYtDynamicConfig config) {
        tableMappings = extractPaths(config);
    }

    @Override
    public Map<Table<?>, String> getTableMappings() {
        return tableMappings;
    }

    private static Map<Table<?>, String> extractPaths(DirectYtDynamicConfig config) {
        return ImmutableMap.<Table<?>, String>builder()
                .put(DIRECTGRIDGOALSSTAT_BS, config.tables().yabsStatTestTables().orderGoalsTestTablePath())
                .put(DIRECTGRIDSTAT_BS, config.tables().yabsStatTestTables().ordersTestTablePath())
                .build();
    }
}
